/*jslint node: true, nomen: true, unparam: true */
/*global jquery, $, _, define, Marionette, jqm, describe, it, expect, beforeEach, afterEach, spyOn */

'use strict';

// Jasmine Unit Testing Suite
define(["jquery", "backbone", "marionette", "jasminejquery"
	, 'applets/wound-care-applet/core/views/RiskFactorsView'],
	function ($, Backbone, Marionette, doNotRemove, RiskFactorsView) {
		
		// Test suite that includes all of the Jasmine unit tests
		describe("Risk Factor", function () {
			var view,
				viewEl,
				collection,
				model;


			beforeEach(function() {


				model = new Backbone.Model({link:['link'],
					riskFactorAssessment:{alterationsInSensation:[{value:'Diabetes Mellitus','object-type':'SkinAssessmentResponseString'}]}
				});
				view = new RiskFactorsView({model:model});
				viewEl = view.render().$el;
			});
			afterEach(function() {
				viewEl.remove();
			});
			it('should have correct fields in the correct order', function() {
				var fields = viewEl.find('[data-role="collapsible"] h2');
				expect(fields.get(0).innerHTML).toBe('Alterations in Sensation');
				expect(fields.get(1).innerHTML).toBe('Alterations in Mobility');
				expect(fields.get(2).innerHTML).toBe('Friction or Shear');
				expect(fields.get(3).innerHTML).toBe('Alterations in Nutrition or Hydration');
				expect(fields.get(4).innerHTML).toBe('Moisture');
				expect(fields.get(5).innerHTML).toBe('Other Diagnoses');
				expect(fields.get(6).innerHTML).toBe('Devices and Equipment');

			});
			it('should not have any past date', function() {
				expect(viewEl.find('label[for="diabetes"]').attr('title')).toBe('');
			});
			describe('with past data', function() {
				beforeEach(function() {
					model = new Backbone.Model({link:['link'],

						riskFactorAssessment:{alterationsInSensation:[{value:'Diabetes Mellitus','object-type':'SkinAssessmentResponseString','datetime':'2014-02-24T14:18:05.954-05:00'}]}
					});
					view = new RiskFactorsView({model:model});
					viewEl = view.render().$el;
				});
				it('should display the dates', function() {
					expect(viewEl.find('label[for="diabetes"]').attr('title')).toBe('Selected 02/24 14:18');
				});
				it('should have the item selected', function() {
					expect(viewEl.find('#diabetes').attr('checked')).toBe('checked');
				});
			});



		});
	});